# F16 — Horizon (Reachability NoCommit) — Passing Simulation Package

This repo contains everything needed to **recreate** the passing F16_v2 run.

## Contents

```
engines/
  ├─ engine_f16_horizon_v2.py        # v2 engine (EXACT code)
  └─ engine_f16_horizon.py           # v1 engine (optional reference, if present)
config/
  ├─ manifest_f16_v2.json            # v2 manifest (EXACT, comment-free)
  └─ manifest_f16_template.json      # v1 template (with comments), if present
scripts/
  └─ run_v2.py                       # one-shot reproducer
results/
  └─ v2/2025-11-05T22-29-19Z/                     # passing run artifacts (CSV, audit, result line, env)
reports/
  └─ REPORT.md                       # why, how, results, interpretation
```

## Prereqs

- **Python 3.8+** (stdlib only; no external packages required)

## Quick start

From the repo root:

```bash
python engines/engine_f16_horizon_v2.py --manifest config/manifest_f16_v2.json --outdir runs/<UTC_timestamp>/
```

or use the helper:

```bash
python scripts/run_v2.py
```

Artifacts will appear under `runs/<UTC_timestamp>/` with the same layout used in the paper/run:

- `outputs/metrics/f16_coarse_per_ray.csv`
- `outputs/metrics/f16_fine_per_ray.csv`
- `outputs/audits/f16_audit.json`
- `outputs/run_info/result_line.txt`
- `logs/env.txt`

## What this certifies

A **hard NoCommit horizon** at radius `radius_shells` by *reachability*:
- Rays with impact **b ≤ R_h fail to reach** the detector (enter r ≤ R_h then stop committing).
- Rays with impact **b > R_h reach** the detector.
- The front is **monotone** (no holes) and **crisp** (edge blur ≤ 1 shell).
- **Interior neutrality** holds (zero commits after first inside r ≤ R_h).
- **Mesh agreement**: coarse vs fine boundary agree within Δb ≤ 1 shell.
